<x-admin-layout>
    <div class="p-6 bg-slate-50 min-h-screen">
        <form action="{{ route('admin.brands.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="max-w-7xl mx-auto">
                <!-- Toolbar -->
                <div class="bg-white p-4 rounded-2xl shadow-lg border border-slate-100 mb-6 flex items-center justify-between gap-4">
                    <h2 class="text-xl font-bold text-slate-800 tracking-tight ml-2">
                        Add Brand
                    </h2>
                    
                    <div class="flex items-center gap-3">
                        <a href="{{ route('admin.brands.index') }}" 
                           class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl text-sm font-semibold text-slate-600 hover:text-slate-800 bg-slate-100 hover:bg-slate-200 transition-all">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="inline-flex items-center gap-2 px-6 py-2.5 rounded-xl text-sm font-semibold text-white bg-gradient-to-r from-emerald-500 to-teal-500 hover:from-emerald-600 hover:to-teal-600 shadow-md hover:shadow-lg transform hover:-translate-y-0.5 transition-all">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                            Publish
                        </button>
                    </div>
                </div>

                <!-- Main Form Card -->
                <div class="bg-white border border-slate-200 rounded-2xl shadow-sm overflow-hidden">
                    <div class="p-8">
                        <div class="space-y-8 max-w-5xl mx-auto">
                            
                            <!-- Name -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center">
                                <label for="name" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Name <span class="text-red-500">*</span>
                                </label>
                                <div class="md:col-span-9">
                                    <input type="text" name="name" id="name" 
                                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-700 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all placeholder-slate-400" 
                                           placeholder="Brand Name" required>
                                    @error('name')
                                        <p class="text-red-500 text-xs mt-1.5 flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Logo -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-start">
                                <label class="md:col-span-3 text-slate-700 font-semibold text-sm pt-2">
                                    Brand Logo <br>
                                    <span class="text-slate-400 font-normal text-xs">(Recommended size)</span>
                                </label>
                                <div class="md:col-span-9 flex items-start gap-6">
                                    <div class="flex-1 relative group cursor-pointer" onclick="document.getElementById('logo').click()">
                                        <div class="border-2 border-dashed border-slate-300 rounded-2xl p-8 text-center bg-slate-50 group-hover:bg-blue-50 group-hover:border-blue-300 transition-all duration-300">
                                            <input type="file" name="logo" id="logo" class="hidden" accept="image/*" onchange="previewImage(this, 'logo-preview')">
                                            <div class="space-y-3">
                                                <div class="w-12 h-12 mx-auto bg-white rounded-full shadow-sm flex items-center justify-center text-blue-500 group-hover:scale-110 transition-transform">
                                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path></svg>
                                                </div>
                                                <div class="text-slate-600 font-medium text-sm group-hover:text-blue-600">Click to upload or drag & drop</div>
                                                <p class="text-xs text-slate-400">SVG, PNG, JPG or GIF</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="w-32 h-32 flex-shrink-0 bg-slate-100 rounded-2xl border border-slate-200 overflow-hidden flex items-center justify-center relative">
                                        <img id="logo-preview" src="#" alt="Preview" class="hidden w-full h-full object-cover">
                                        <div id="logo-placeholder" class="text-center p-2">
                                            <svg class="w-8 h-8 text-slate-300 mx-auto mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                            <span class="text-xs text-slate-400 block">No image</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center">
                                <label for="status" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Status
                                </label>
                                <div class="md:col-span-9">
                                    <div class="relative">
                                        <select name="status" id="status" 
                                                class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-700 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all appearance-none cursor-pointer">
                                            <option value="1">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                        <div class="absolute inset-y-0 right-0 flex items-center px-4 pointer-events-none text-slate-500">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            const placeholder = document.getElementById(previewId.replace('preview', 'placeholder'));
            
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                    placeholder.classList.add('hidden');
                }
                
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.src = '#';
                preview.classList.add('hidden');
                placeholder.classList.remove('hidden');
            }
        }
    </script>
</x-admin-layout>
