<x-admin-layout>
    <div class="p-6 bg-slate-50 min-h-screen">
        <div class="bg-white p-4 rounded-2xl shadow-lg border border-slate-100 mb-6 flex justify-between items-center">
            <h2 class="text-xl font-bold text-slate-800 tracking-tight">Edit Banner</h2>
            <a href="{{ route('admin.banners.index') }}" class="text-blue-600 hover:text-blue-800 font-semibold text-sm">Back to List</a>
        </div>

        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4" role="alert">
                <ul class="list-disc list-inside text-sm text-red-700">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="bg-white p-6 rounded-2xl shadow-sm border border-slate-200">
            <form action="{{ route('admin.banners.update', $banner->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Title -->
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                        <input type="text" name="title" value="{{ old('title', $banner->title) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="Enter banner title">
                    </div>

                    <!-- Subtitle -->
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Subtitle</label>
                        <input type="text" name="subtitle" value="{{ old('subtitle', $banner->subtitle) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="Enter banner subtitle">
                    </div>

                    <!-- Text Position -->
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Text Position</label>
                        <select name="text_position" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            <option value="left" {{ old('text_position', $banner->text_position) == 'left' ? 'selected' : '' }}>Left</option>
                            <option value="center" {{ old('text_position', $banner->text_position ?? 'center') == 'center' ? 'selected' : '' }}>Center</option>
                            <option value="right" {{ old('text_position', $banner->text_position) == 'right' ? 'selected' : '' }}>Right</option>
                        </select>
                    </div>

                    <!-- Banner Category (Placement) -->
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Banner Placement</label>
                        <select name="banner_category_id" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                            <option value="">Select Placement</option>
                            @foreach($categories as $category)
                                <option value="{{ $category->id }}" {{ old('banner_category_id', $banner->banner_category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Image -->
                    <div class="mb-4">
                        <label class="block text-gray-700 text-sm font-bold mb-2">Banner Image</label>
                        <input type="file" name="image" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                        <p class="text-xs text-gray-500 mt-1">Leave empty to keep current image. Recommended size: 1920x600px.</p>
                        @if($banner->image)
                            <div class="mt-2">
                                <img src="{{ asset('storage/' . $banner->image) }}" alt="Current Image" class="h-20 w-auto rounded border">
                            </div>
                        @endif
                    </div>

                    <!-- Link Destination Logic -->
                    <div class="col-span-1 md:col-span-2 bg-blue-50 p-4 rounded-lg mb-4 border border-blue-100">
                        <h3 class="text-sm font-bold text-blue-800 mb-3">Link Destination</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Product Category Link -->
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2">Link to Product Category</label>
                                <select name="product_category_id" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                                    <option value="">Select Product Category (Optional)</option>
                                    @foreach($productCategories as $pCategory)
                                        <option value="{{ $pCategory->id }}" {{ old('product_category_id', $banner->product_category_id) == $pCategory->id ? 'selected' : '' }}>{{ $pCategory->name }}</option>
                                    @endforeach
                                </select>
                                <p class="text-xs text-gray-500 mt-1">If selected, the banner will link to this category page.</p>
                            </div>

                            <!-- Custom URL -->
                            <div class="mb-4">
                                <label class="block text-gray-700 text-sm font-bold mb-2">OR Custom URL</label>
                                <input type="text" name="url" value="{{ old('url', $banner->url) }}" class="shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" placeholder="e.g. /shop or https://example.com">
                                <p class="text-xs text-gray-500 mt-1">Used only if no Product Category is selected above.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="mb-6 flex items-center">
                    <input type="checkbox" name="status" id="status" class="mr-2 leading-tight" {{ old('status', $banner->status) ? 'checked' : '' }}>
                    <label class="block text-gray-700 text-sm font-bold" for="status">
                        Active
                    </label>
                </div>

                <div class="flex items-center justify-end">
                    <button type="submit" class="bg-blue-600 text-white font-bold py-2 px-6 rounded-lg hover:bg-blue-700 transition duration-150 ease-in-out shadow-md">
                        Update Banner
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>