<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('SMS API Settings') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <style>
            @keyframes slideInUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            .animate-slide-up {
                animation: slideInUp 0.5s ease-out forwards;
            }
            .animation-delay-100 { animation-delay: 0.1s; }
            .animation-delay-200 { animation-delay: 0.2s; }
            .animation-delay-300 { animation-delay: 0.3s; }
        </style>
        <div class="max-w-7xl mx-auto space-y-8 px-4 sm:px-6 lg:px-8">
            
            @if (session('success'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Success</p>
                    <p>{{ session('success') }}</p>
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Error</p>
                    <p>{{ session('error') }}</p>
                </div>
            @endif

            @if (session('sms_result'))
                <div class="bg-indigo-100 border-l-4 border-indigo-500 text-indigo-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">SMS Sent Successfully</p>
                    <p>Message ID: {{ session('sms_result')['message_id'] ?? 'N/A' }}</p>
                    <p>Cost: {{ session('sms_result')['cost'] ?? 'N/A' }} credits</p>
                </div>
            @endif

            <!-- Quick SMS Check -->
            <div class="bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500 rounded-2xl shadow-xl p-0.5 animate-slide-up">
                <div class="bg-white rounded-2xl p-6">
                    <div class="flex items-center mb-4">
                        <div class="h-8 w-8 rounded-lg bg-indigo-100 flex items-center justify-center text-indigo-600 mr-3">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-800">Quick SMS Check</h3>
                    </div>
                    <form action="{{ route('admin.api.sms.test') }}" method="POST" class="flex flex-col sm:flex-row items-center gap-4">
                    @csrf
                    <div class="w-full sm:flex-1 relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                            </svg>
                        </div>
                        <input type="text" name="phone" placeholder="Enter phone number to check..." class="w-full pl-10 rounded-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" required>
                    </div>
                    <input type="hidden" name="message" value="Welcome! This is a test message from your system.">
                    <button type="submit" class="w-full sm:w-auto bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2.5 px-8 rounded-lg shadow transition duration-150 ease-in-out whitespace-nowrap flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        Check
                    </button>
                </form>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Left Column: Balance & Test -->
                <div class="lg:col-span-1 space-y-6 animate-slide-up animation-delay-100">
                    <div class="bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl shadow-xl border border-indigo-500/30 h-full relative overflow-hidden group hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-1">
                        <div class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 rounded-full bg-white opacity-10 blur-xl group-hover:scale-110 transition-transform duration-500"></div>
                        <div class="absolute bottom-0 left-0 -mb-4 -ml-4 w-24 h-24 rounded-full bg-indigo-400 opacity-20 blur-lg group-hover:scale-110 transition-transform duration-500"></div>
                        
                        <div class="p-8 flex flex-col items-center justify-center h-full relative z-10" x-data="{ balance: null, loading: false, error: null }" x-init="
                             loading = true; 
                             fetch('{{ route('admin.api.sms.balance') }}')
                                 .then(res => res.json())
                                 .then(data => {
                                     if(data.status === 'success' || data.remaining_credits !== undefined) {
                                         balance = data.remaining_credits;
                                     } else {
                                         error = data.message || 'Error fetching balance';
                                     }
                                     loading = false;
                                 })
                                 .catch(err => {
                                     error = 'Invalid API key';
                                     loading = false;
                                });
                        ">
                            <div class="bg-white/20 p-4 rounded-full mb-5 backdrop-blur-md shadow-inner">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            
                            <h3 class="text-blue-100 font-medium mb-1 text-lg">Current SMS Balance</h3>
                            
                            <div class="text-5xl font-bold mb-8 tracking-tight text-white drop-shadow-sm">
                                <span x-show="loading" class="text-blue-200 text-3xl animate-pulse">...</span>
                                <span x-show="!loading && balance !== null" x-text="balance"></span>
                                <span x-show="!loading && error" x-text="error" class="text-red-200 text-sm bg-red-900/50 px-2 py-1 rounded"></span>
                            </div>

                            <button @click="
                                loading = true; 
                                error = null;
                                fetch('{{ route('admin.api.sms.balance') }}')
                                    .then(res => res.json())
                                    .then(data => {
                                        if(data.status === 'success' || data.remaining_credits !== undefined) {
                                            balance = data.remaining_credits;
                                        } else {
                                            error = data.message || 'Error fetching balance';
                                        }
                                        loading = false;
                                    })
                                    .catch(err => {
                                        error = 'Network error';
                                        loading = false;
                                    });
                            " class="inline-flex items-center px-6 py-2 bg-white/20 hover:bg-white/30 border border-transparent rounded-lg font-semibold text-xs text-white uppercase tracking-widest shadow-md backdrop-blur-sm transition ease-in-out duration-150 transform hover:-translate-y-0.5 active:translate-y-0">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                </svg>
                                Check Balance
                            </button>
                        </div>
                    </div>

                </div>

                <!-- Right Column: Settings -->
                <div class="lg:col-span-2 animate-slide-up animation-delay-200">
                    <div class="bg-white overflow-hidden shadow-xl sm:rounded-2xl border border-gray-100 relative group hover:shadow-2xl transition-all duration-300">
                        <div class="absolute top-0 left-0 right-0 h-1.5 bg-gradient-to-r from-blue-500 via-indigo-500 to-purple-500"></div>
                        <div class="p-8">
                            <div class="flex items-center justify-between mb-8 border-b border-gray-100 pb-4">
                                <h3 class="text-xl font-bold text-gray-800 flex items-center">
                                    <span class="bg-indigo-100 text-indigo-600 p-2 rounded-lg mr-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                    </span>
                                    SMS Configuration
                                </h3>
                                <div class="text-sm text-gray-500 bg-gray-50 px-3 py-1 rounded-full border border-gray-200">
                                    Provider: <span class="font-semibold text-indigo-600">FraudChecker.link</span>
                                </div>
                            </div>
                            
                            <form action="{{ route('admin.api.sms.update') }}" method="POST">
                                @csrf
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
                                    <div class="relative">
                                        <label class="block text-sm font-semibold text-gray-700 mb-2">SMS API URL</label>
                                        <div class="flex rounded-md shadow-sm">
                                            <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 sm:text-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1" />
                                                </svg>
                                            </span>
                                            <input type="text" value="https://fraudchecker.link/api/v1/sms/" disabled class="flex-1 min-w-0 block w-full px-3 py-2 rounded-none rounded-r-md border-gray-300 bg-gray-50 text-gray-500 sm:text-sm focus:ring-indigo-500 focus:border-indigo-500">
                                        </div>
                                        <p class="mt-2 text-xs text-gray-400 flex items-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3 mr-1" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                                            </svg>
                                            This URL is locked and managed by the system
                                        </p>
                                    </div>
                                    <div>
                                        <label for="sms_api_key" class="block text-sm font-semibold text-gray-700 mb-2">API Key <span class="text-red-500">*</span></label>
                                        <div class="relative rounded-md shadow-sm">
                                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11.536 9.464l-1.414 1.414a2 2 0 01-2.828 0l-1.414-1.414a2 2 0 010-2.828l1.414-1.414L9 5.343 8.657 5A6 6 0 0118 8v.5z" />
                                                </svg>
                                            </div>
                                            <input type="text" name="sms_api_key" id="sms_api_key" value="{{ old('sms_api_key', $setting->sms_api_key ?? '') }}" class="focus:ring-indigo-500 focus:border-indigo-500 block w-full pl-10 sm:text-sm border-gray-300 rounded-md py-2.5" placeholder="Enter your API key here" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="bg-gray-50 rounded-xl p-6 mb-8 border border-gray-100">
                                    <h4 class="text-sm font-semibold text-gray-500 uppercase tracking-wider mb-4">Notification Triggers</h4>
                                    <div class="grid grid-cols-2 lg:grid-cols-4 gap-6">
                                        <!-- Status Toggle -->
                                        <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                                            <label class="block text-sm font-medium text-gray-700 mb-3 flex items-center justify-between">
                                                Global Status
                                                <span class="relative flex h-2 w-2">
                                                  <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
                                                  <span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
                                                </span>
                                            </label>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="sms_active" value="1" class="sr-only peer" {{ ($setting->sms_active ?? false) ? 'checked' : '' }}>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                                <span class="ml-3 text-xs font-medium text-gray-500 peer-checked:text-indigo-600">{{ ($setting->sms_active ?? false) ? 'Active' : 'Inactive' }}</span>
                                            </label>
                                        </div>

                                        <!-- Order Confirm Toggle -->
                                        <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                                            <label class="block text-sm font-medium text-gray-700 mb-3">Order Confirm</label>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="sms_order_confirm" value="1" class="sr-only peer" {{ ($setting->sms_order_confirm ?? false) ? 'checked' : '' }}>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                                <span class="ml-3 text-xs font-medium text-gray-500 peer-checked:text-indigo-600">Enable</span>
                                            </label>
                                        </div>

                                        <!-- Forgot Password Toggle -->
                                        <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                                            <label class="block text-sm font-medium text-gray-700 mb-3">Forgot Password</label>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="sms_forgot_password" value="1" class="sr-only peer" {{ ($setting->sms_forgot_password ?? false) ? 'checked' : '' }}>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                                <span class="ml-3 text-xs font-medium text-gray-500 peer-checked:text-indigo-600">Enable</span>
                                            </label>
                                        </div>

                                        <!-- Password Generator Toggle -->
                                        <div class="bg-white p-4 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                                            <label class="block text-sm font-medium text-gray-700 mb-3">Password Gen</label>
                                            <label class="relative inline-flex items-center cursor-pointer">
                                                <input type="checkbox" name="sms_password_generator" value="1" class="sr-only peer" {{ ($setting->sms_password_generator ?? false) ? 'checked' : '' }}>
                                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-indigo-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                                                <span class="ml-3 text-xs font-medium text-gray-500 peer-checked:text-indigo-600">Enable</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="flex items-center justify-end">
                                    <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white font-semibold py-3 px-6 rounded-lg shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200 flex items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4" />
                                        </svg>
                                        Save Configuration
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Info Section -->
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-2xl border border-gray-100 p-8 animate-slide-up animation-delay-300 relative group hover:shadow-2xl transition-all duration-300">
                <div class="absolute top-0 left-0 right-0 h-1.5 bg-gradient-to-r from-purple-500 via-pink-500 to-red-500"></div>
                <div class="flex items-center mb-8">
                    <div class="bg-indigo-100 p-3 rounded-full mr-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-indigo-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h4 class="text-xl font-bold text-gray-800">
                        Setup Guide: <span class="text-indigo-600">FraudChecker.link SMS API</span>
                    </h4>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                    <!-- Step 1 -->
                    <div class="bg-blue-50 hover:bg-blue-100 p-6 rounded-2xl border border-blue-100 shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group relative">
                        <div class="absolute top-0 right-0 -mt-2 -mr-2 w-16 h-16 bg-blue-200 rounded-full opacity-20 group-hover:scale-125 transition-transform duration-500"></div>
                        <h5 class="text-blue-800 font-bold mb-3 flex items-center">
                            <span class="bg-blue-200 text-blue-700 w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold mr-3 shadow-sm group-hover:bg-blue-600 group-hover:text-white transition-colors duration-300">1</span>
                            Registration
                        </h5>
                        <ul class="text-sm text-blue-900 space-y-2 list-none ml-11">
                            <li class="flex items-start">
                                <span class="text-blue-500 mr-2 font-bold">•</span>
                                <span>Go to <a href="https://fraudchecker.link" target="_blank" class="text-blue-700 font-bold hover:underline">fraudchecker.link</a></span>
                            </li>
                            <li class="flex items-start">
                                <span class="text-blue-500 mr-2 font-bold">•</span>
                                <span>Create a new account</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Step 2 -->
                    <div class="bg-indigo-50 hover:bg-indigo-100 p-6 rounded-2xl border border-indigo-100 shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group relative">
                        <div class="absolute top-0 right-0 -mt-2 -mr-2 w-16 h-16 bg-indigo-200 rounded-full opacity-20 group-hover:scale-125 transition-transform duration-500"></div>
                        <h5 class="text-indigo-800 font-bold mb-3 flex items-center">
                            <span class="bg-indigo-200 text-indigo-700 w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold mr-3 shadow-sm group-hover:bg-indigo-600 group-hover:text-white transition-colors duration-300">2</span>
                            Login
                        </h5>
                        <ul class="text-sm text-indigo-900 space-y-2 list-none ml-11">
                            <li class="flex items-start">
                                <span class="text-indigo-500 mr-2 font-bold">•</span>
                                <span>Login to your dashboard</span>
                            </li>
                            <li class="flex items-start">
                                <span class="text-indigo-500 mr-2 font-bold">•</span>
                                <span>Get free trial SMS</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Step 3 -->
                    <div class="bg-violet-50 hover:bg-violet-100 p-6 rounded-2xl border border-violet-100 shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group relative">
                        <div class="absolute top-0 right-0 -mt-2 -mr-2 w-16 h-16 bg-violet-200 rounded-full opacity-20 group-hover:scale-125 transition-transform duration-500"></div>
                        <h5 class="text-violet-800 font-bold mb-3 flex items-center">
                            <span class="bg-violet-200 text-violet-700 w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold mr-3 shadow-sm group-hover:bg-violet-600 group-hover:text-white transition-colors duration-300">3</span>
                            Purchase SMS
                        </h5>
                        <ul class="text-sm text-violet-900 space-y-2 list-none ml-11">
                            <li class="flex items-start">
                                <span class="text-violet-500 mr-2 font-bold">•</span>
                                <span>Go to Panel → SMS Packages</span>
                            </li>
                            <li class="flex items-start">
                                <span class="text-violet-500 mr-2 font-bold">•</span>
                                <span>Pay via bKash/Nagad/Rocket</span>
                            </li>
                        </ul>
                    </div>

                    <!-- Step 4 -->
                    <div class="bg-fuchsia-50 hover:bg-fuchsia-100 p-6 rounded-2xl border border-fuchsia-100 shadow-md hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2 group relative">
                        <div class="absolute top-0 right-0 -mt-2 -mr-2 w-16 h-16 bg-fuchsia-200 rounded-full opacity-20 group-hover:scale-125 transition-transform duration-500"></div>
                        <h5 class="text-fuchsia-800 font-bold mb-3 flex items-center">
                            <span class="bg-fuchsia-200 text-fuchsia-700 w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold mr-3 shadow-sm group-hover:bg-fuchsia-600 group-hover:text-white transition-colors duration-300">4</span>
                            Get API Key
                        </h5>
                        <ul class="text-sm text-fuchsia-900 space-y-2 list-none ml-11">
                            <li class="flex items-start">
                                <span class="text-fuchsia-500 mr-2 font-bold">•</span>
                                <span>Go to Panel → Developer API</span>
                            </li>
                            <li class="flex items-start">
                                <span class="text-fuchsia-500 mr-2 font-bold">•</span>
                                <span>Copy API Key & Paste above</span>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="bg-gradient-to-r from-violet-600 to-indigo-600 shadow-lg p-6 rounded-xl flex flex-col sm:flex-row items-center justify-between relative overflow-hidden">
                    <div class="absolute top-0 right-0 -mt-10 -mr-10 w-40 h-40 bg-white opacity-10 rounded-full blur-2xl"></div>
                    <div class="absolute bottom-0 left-0 -mb-10 -ml-10 w-40 h-40 bg-white opacity-10 rounded-full blur-2xl"></div>
                    
                    <div class="flex items-center mb-4 sm:mb-0 relative z-10">
                        <div class="bg-white/20 p-3 rounded-full mr-4 backdrop-blur-sm">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div>
                            <h5 class="font-bold text-white text-lg">Why choose FraudChecker SMS?</h5>
                            <p class="text-sm text-indigo-100">Fast delivery, low cost, 100% reliable, supports all operators.</p>
                        </div>
                    </div>
                    
                    <a href="https://fraudchecker.link" target="_blank" class="relative z-10 inline-flex items-center px-6 py-3 bg-white border border-transparent rounded-lg font-bold text-sm text-indigo-600 uppercase tracking-wider hover:bg-indigo-50 active:bg-indigo-100 focus:outline-none focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150 shadow-lg transform hover:-translate-y-0.5">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                        </svg>
                        Visit FraudChecker.link
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
