<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Payment Gateway Settings') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <style>
            @keyframes slideInUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            .animate-slide-up {
                animation: slideInUp 0.5s ease-out forwards;
            }
            .animation-delay-100 { animation-delay: 0.1s; }
            .animation-delay-200 { animation-delay: 0.2s; }
        </style>
        
        <div class="max-w-7xl mx-auto space-y-8 px-4 sm:px-6 lg:px-8">
            
            @if (session('success'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Success</p>
                    <p>{{ session('success') }}</p>
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Error</p>
                    <p>{{ session('error') }}</p>
                </div>
            @endif

            <form action="{{ route('admin.api.payment.update') }}" method="POST" class="space-y-8">
                @csrf
                
                <!-- bKash Merchant Settings -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg animate-slide-up">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center">
                                <div class="bg-pink-100 p-2 rounded-lg mr-3">
                                    <svg class="w-8 h-8 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-bold text-gray-800">bKash Merchant API</h3>
                                    <p class="text-sm text-gray-500">Configure your bKash Payment Gateway</p>
                                </div>
                            </div>
                            
                            <!-- Toggle Switch -->
                            <label for="bkash_enabled" class="flex items-center cursor-pointer">
                                <div class="relative">
                                    <input type="checkbox" id="bkash_enabled" name="bkash_enabled" class="sr-only" {{ $setting->bkash_enabled ? 'checked' : '' }}>
                                    <div class="block bg-gray-200 w-14 h-8 rounded-full transition-colors duration-300 ease-in-out" id="bkash_toggle_bg"></div>
                                    <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition-transform duration-300 ease-in-out shadow" id="bkash_toggle_dot"></div>
                                </div>
                                <div class="ml-3 text-gray-700 font-medium">Enable</div>
                            </label>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- App Key -->
                            <div class="col-span-1">
                                <label for="bkash_app_key" class="block text-sm font-medium text-gray-700 mb-1">App Key</label>
                                <input type="text" name="bkash_app_key" id="bkash_app_key" value="{{ $setting->bkash_app_key }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-pink-500 focus:ring-pink-500 transition-colors">
                            </div>

                            <!-- App Secret -->
                            <div class="col-span-1">
                                <label for="bkash_app_secret" class="block text-sm font-medium text-gray-700 mb-1">App Secret</label>
                                <input type="text" name="bkash_app_secret" id="bkash_app_secret" value="{{ $setting->bkash_app_secret }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-pink-500 focus:ring-pink-500 transition-colors">
                            </div>

                            <!-- Username -->
                            <div class="col-span-1">
                                <label for="bkash_username" class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                                <input type="text" name="bkash_username" id="bkash_username" value="{{ $setting->bkash_username }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-pink-500 focus:ring-pink-500 transition-colors">
                            </div>

                            <!-- Password -->
                            <div class="col-span-1">
                                <label for="bkash_password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                                <input type="text" name="bkash_password" id="bkash_password" value="{{ $setting->bkash_password }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-pink-500 focus:ring-pink-500 transition-colors">
                            </div>

                            <!-- Test Mode -->
                            <div class="col-span-1 md:col-span-2">
                                <label class="flex items-center space-x-3 cursor-pointer">
                                    <input type="checkbox" name="bkash_test_mode" class="rounded border-gray-300 text-pink-600 shadow-sm focus:border-pink-500 focus:ring-pink-500 h-5 w-5" {{ $setting->bkash_test_mode ? 'checked' : '' }}>
                                    <span class="text-sm font-medium text-gray-700">Enable Sandbox Mode (Test Mode)</span>
                                </label>
                                <p class="text-xs text-gray-500 mt-1 ml-8">Uncheck this for Live Production usage.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- SSLCommerz Settings -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg animate-slide-up animation-delay-100">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center">
                                <div class="bg-blue-100 p-2 rounded-lg mr-3">
                                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="text-lg font-bold text-gray-800">SSLCommerz</h3>
                                    <p class="text-sm text-gray-500">Configure your SSLCommerz Payment Gateway</p>
                                </div>
                            </div>
                            
                            <!-- Toggle Switch -->
                            <label for="sslcz_enabled" class="flex items-center cursor-pointer">
                                <div class="relative">
                                    <input type="checkbox" id="sslcz_enabled" name="sslcz_enabled" class="sr-only" {{ $setting->sslcz_enabled ? 'checked' : '' }}>
                                    <div class="block bg-gray-200 w-14 h-8 rounded-full transition-colors duration-300 ease-in-out" id="sslcz_toggle_bg"></div>
                                    <div class="dot absolute left-1 top-1 bg-white w-6 h-6 rounded-full transition-transform duration-300 ease-in-out shadow" id="sslcz_toggle_dot"></div>
                                </div>
                                <div class="ml-3 text-gray-700 font-medium">Enable</div>
                            </label>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Store ID -->
                            <div class="col-span-1">
                                <label for="sslcz_store_id" class="block text-sm font-medium text-gray-700 mb-1">Store ID</label>
                                <input type="text" name="sslcz_store_id" id="sslcz_store_id" value="{{ $setting->sslcz_store_id }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 transition-colors">
                            </div>

                            <!-- Store Password -->
                            <div class="col-span-1">
                                <label for="sslcz_store_password" class="block text-sm font-medium text-gray-700 mb-1">Store Password</label>
                                <input type="text" name="sslcz_store_password" id="sslcz_store_password" value="{{ $setting->sslcz_store_password }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 transition-colors">
                            </div>

                            <!-- Test Mode -->
                            <div class="col-span-1 md:col-span-2">
                                <label class="flex items-center space-x-3 cursor-pointer">
                                    <input type="checkbox" name="sslcz_test_mode" class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-500 focus:ring-blue-500 h-5 w-5" {{ $setting->sslcz_test_mode ? 'checked' : '' }}>
                                    <span class="text-sm font-medium text-gray-700">Enable Sandbox Mode (Test Mode)</span>
                                </label>
                                <p class="text-xs text-gray-500 mt-1 ml-8">Uncheck this for Live Production usage.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end animate-slide-up animation-delay-200">
                    <button type="submit" class="bg-gradient-to-r from-gray-800 to-gray-900 hover:from-gray-700 hover:to-gray-800 text-white font-bold py-3 px-8 rounded-lg shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                        Save Settings
                    </button>
                </div>
            </form>
        </div>
    </div>

    <style>
        /* Toggle Switch Styles */
        input:checked ~ #bkash_toggle_bg {
            background-color: #ec4899; /* pink-500 */
        }
        input:checked ~ #bkash_toggle_dot {
            transform: translateX(100%);
        }
        input:checked ~ #sslcz_toggle_bg {
            background-color: #3b82f6; /* blue-500 */
        }
        input:checked ~ #sslcz_toggle_dot {
            transform: translateX(100%);
        }
    </style>
</x-admin-layout>
