<x-admin-layout>
    <div class="py-12 min-h-screen relative overflow-hidden bg-gray-50">
        <!-- Decorative Background Elements -->
        <div class="absolute inset-0 z-0 pointer-events-none">
            <div class="absolute top-0 left-1/4 w-96 h-96 bg-blue-100 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob"></div>
            <div class="absolute top-0 right-1/4 w-96 h-96 bg-purple-100 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob animation-delay-2000"></div>
            <div class="absolute -bottom-32 left-1/3 w-96 h-96 bg-pink-100 rounded-full mix-blend-multiply filter blur-3xl opacity-30 animate-blob animation-delay-4000"></div>
            <svg class="absolute w-full h-full opacity-[0.03]" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <pattern id="grid-pattern" width="40" height="40" patternUnits="userSpaceOnUse">
                        <path d="M0 40L40 0H20L0 20M40 40V20L20 40" stroke="currentColor" stroke-width="2" class="text-gray-900" fill="none"/>
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid-pattern)" />
            </svg>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <!-- Header Section -->
            <div class="mb-12 text-center">
                <div class="inline-flex items-center justify-center p-4 bg-white rounded-3xl shadow-xl mb-6 transform hover:scale-110 transition-transform duration-300 ring-4 ring-white/50">
                    <div class="bg-gradient-to-br from-indigo-500 to-purple-600 p-3 rounded-2xl">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                        </svg>
                    </div>
                </div>
                <h1 class="text-5xl font-black text-transparent bg-clip-text bg-gradient-to-r from-gray-900 via-indigo-900 to-gray-900 mb-4 tracking-tight">
                    Fraud Detection Hub
                </h1>
                <p class="text-xl text-gray-600 max-w-2xl mx-auto leading-relaxed">
                    Advanced analytics to protect your business. Configure API and verify customers in real-time.
                </p>
            </div>

            <!-- Alerts -->
            @if (session('success'))
                <div class="mb-8 bg-green-50/90 backdrop-blur-sm border-l-4 border-green-500 p-4 rounded-r-xl shadow-lg animate-fade-in-down flex items-center">
                    <div class="flex-shrink-0 bg-green-100 p-2 rounded-full">
                        <svg class="h-5 w-5 text-green-600" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-bold text-green-800">{{ session('success') }}</p>
                    </div>
                </div>
            @endif

            @if (session('error'))
                <div class="mb-8 bg-red-50/90 backdrop-blur-sm border-l-4 border-red-500 p-4 rounded-r-xl shadow-lg animate-fade-in-down flex items-center">
                    <div class="flex-shrink-0 bg-red-100 p-2 rounded-full">
                        <svg class="h-5 w-5 text-red-600" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-bold text-red-800">{{ session('error') }}</p>
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 xl:grid-cols-2 gap-10 items-start">
                
                <!-- Configuration Card -->
                <div class="group bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100 hover:shadow-2xl transition-all duration-300 hover:-translate-y-1">
                    <div class="relative bg-gray-900 px-8 py-8 overflow-hidden">
                        <div class="absolute inset-0 opacity-20 bg-gradient-to-r from-indigo-600 to-purple-600"></div>
                        <div class="relative z-10 flex items-center justify-between">
                            <div>
                                <h3 class="text-2xl font-bold text-white flex items-center gap-3">
                                    <span class="p-2 bg-white/10 rounded-lg backdrop-blur-sm">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        </svg>
                                    </span>
                                    API Settings
                                </h3>
                                <p class="text-indigo-200 text-sm mt-1 ml-1">Configure your connection</p>
                            </div>
                            <span class="bg-indigo-500/20 text-indigo-100 text-xs font-bold px-3 py-1.5 rounded-full border border-indigo-500/30">SECURE</span>
                        </div>
                    </div>
                    
                    <div class="p-8 bg-white">
                        <form action="{{ route('admin.api.fraud.update') }}" method="POST" class="space-y-6">
                            @csrf
                            <div class="relative group/input">
                                <label for="fraud_api_key" class="block text-sm font-bold text-gray-700 mb-2 uppercase tracking-wide">API Key</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400 group-focus-within/input:text-indigo-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11.536 19.464a2 2 0 01-.5.5l-2.172 2.172a2 2 0 01-1.414 0l-4.243-4.243a2 2 0 010-1.414l2.172-2.172a2 2 0 01.5-.5l1.086-1.086c.35.036.708.056 1.071.056a6 6 0 015.743-7.743z"></path>
                                        </svg>
                                    </div>
                                    <input type="text" name="fraud_api_key" id="fraud_api_key" 
                                        value="{{ old('fraud_api_key', $setting->fraud_api_key ?? '') }}" 
                                        class="block w-full pl-11 pr-4 py-4 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:ring-2 focus:ring-indigo-500 focus:border-transparent focus:bg-white transition-all duration-200 font-mono text-sm shadow-sm" 
                                        required 
                                        placeholder="Paste your API key here...">
                                </div>
                                <div class="mt-3 flex items-center gap-2">
                                    <div class="h-1 w-1 rounded-full bg-indigo-500"></div>
                                    <p class="text-xs text-gray-500">
                                        Don't have a key? <a href="https://fraudchecker.link" target="_blank" class="text-indigo-600 hover:text-indigo-800 font-bold hover:underline">Get it here</a>
                                    </p>
                                </div>
                            </div>

                            <div class="pt-2">
                                <button type="submit" class="w-full flex justify-center items-center gap-2 py-4 px-6 border border-transparent rounded-xl shadow-lg text-sm font-bold text-white bg-gray-900 hover:bg-gray-800 focus:outline-none focus:ring-4 focus:ring-gray-300 transition-all duration-200 transform active:scale-95 group-hover:shadow-indigo-500/30">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"></path>
                                    </svg>
                                    Save Configuration
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Testing Card -->
                <div class="group bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100 hover:shadow-2xl transition-all duration-300 flex flex-col h-full hover:-translate-y-1">
                    <div class="relative bg-emerald-600 px-8 py-8 overflow-hidden">
                        <div class="absolute inset-0 opacity-20 bg-[radial-gradient(ellipse_at_top_right,_var(--tw-gradient-stops))] from-emerald-300 via-teal-400 to-teal-900"></div>
                        <div class="relative z-10 flex items-center justify-between">
                            <div>
                                <h3 class="text-2xl font-bold text-white flex items-center gap-3">
                                    <span class="p-2 bg-white/10 rounded-lg backdrop-blur-sm">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                    </span>
                                    Instant Check
                                </h3>
                                <p class="text-emerald-100 text-sm mt-1 ml-1">Verify customer reliability</p>
                            </div>
                            <span class="bg-emerald-400/20 text-emerald-50 text-xs font-bold px-3 py-1.5 rounded-full border border-emerald-400/30 animate-pulse">LIVE</span>
                        </div>
                    </div>
                    
                    <div class="p-8 flex-grow flex flex-col bg-white">
                        <form action="{{ route('admin.api.fraud.check') }}" method="POST" class="space-y-6 mb-8">
                            @csrf
                            <div class="relative group/input">
                                <label for="phone" class="block text-sm font-bold text-gray-700 mb-2 uppercase tracking-wide">Customer Phone</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                                        <svg class="h-5 w-5 text-gray-400 group-focus-within/input:text-emerald-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                                        </svg>
                                    </div>
                                    <input type="text" name="phone" id="phone" 
                                        placeholder="017xxxxxxxx" 
                                        class="block w-full pl-11 pr-4 py-4 bg-gray-50 border border-gray-200 rounded-xl text-gray-900 placeholder-gray-400 focus:ring-2 focus:ring-emerald-500 focus:border-transparent focus:bg-white transition-all duration-200 font-mono text-lg shadow-sm tracking-wider" 
                                        required>
                                </div>
                            </div>

                            <div class="pt-2">
                                <button type="submit" class="w-full flex justify-center items-center gap-2 py-4 px-6 border border-transparent rounded-xl shadow-lg text-sm font-bold text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-4 focus:ring-emerald-200 transition-all duration-200 transform active:scale-95 group-hover:shadow-emerald-500/30">
                                    <svg class="w-5 h-5 animate-spin-slow" fill="none" stroke="currentColor" viewBox="0 0 24 24" style="display:none">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                    </svg>
                                    Analyze Number
                                </button>
                            </div>
                        </form>

                        @if (session('fraud_result'))
                            @php
                                $total = session('fraud_result')['total_parcels'] ?? 0;
                                $delivered = session('fraud_result')['total_delivered'] ?? 0;
                                $cancelled = session('fraud_result')['total_cancel'] ?? 0;
                                $deliveryRate = $total > 0 ? round(($delivered / $total) * 100) : 0;
                                
                                // Default Risk Theme (Red)
                                $theme = [
                                    'bg' => 'bg-red-50',
                                    'border' => 'border-red-100',
                                    'header_bg' => 'bg-red-100/50',
                                    'header_border' => 'border-red-200',
                                    'icon_bg' => 'bg-red-200',
                                    'icon_text' => 'text-red-700',
                                    'title' => 'text-red-800',
                                    'timestamp' => 'text-red-700',
                                    'score' => 'text-red-600',
                                    'sub_score' => 'text-red-600/70',
                                    'badge' => 'bg-red-500 shadow-red-200',
                                    'hover_border' => 'hover:border-red-200',
                                    'hover_text' => 'group-hover/stat:text-red-600',
                                    'divider' => 'border-red-200/50',
                                    'level' => 'Risky',
                                    'icon' => 'M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z'
                                ];

                                if ($total > 0) {
                                    if ($deliveryRate >= 80) {
                                        // Safe Theme (Emerald)
                                        $theme = [
                                            'bg' => 'bg-emerald-50',
                                            'border' => 'border-emerald-100',
                                            'header_bg' => 'bg-emerald-100/50',
                                            'header_border' => 'border-emerald-200',
                                            'icon_bg' => 'bg-emerald-200',
                                            'icon_text' => 'text-emerald-700',
                                            'title' => 'text-emerald-800',
                                            'timestamp' => 'text-emerald-700',
                                            'score' => 'text-emerald-600',
                                            'sub_score' => 'text-emerald-600/70',
                                            'badge' => 'bg-emerald-500 shadow-emerald-200',
                                            'hover_border' => 'hover:border-emerald-200',
                                            'hover_text' => 'group-hover/stat:text-emerald-600',
                                            'divider' => 'border-emerald-200/50',
                                            'level' => 'Safe',
                                            'icon' => 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z'
                                        ];
                                    } elseif ($deliveryRate >= 50) {
                                        // Average Theme (Yellow)
                                        $theme = [
                                            'bg' => 'bg-yellow-50',
                                            'border' => 'border-yellow-100',
                                            'header_bg' => 'bg-yellow-100/50',
                                            'header_border' => 'border-yellow-200',
                                            'icon_bg' => 'bg-yellow-200',
                                            'icon_text' => 'text-yellow-700',
                                            'title' => 'text-yellow-800',
                                            'timestamp' => 'text-yellow-700',
                                            'score' => 'text-yellow-600',
                                            'sub_score' => 'text-yellow-600/70',
                                            'badge' => 'bg-yellow-500 shadow-yellow-200',
                                            'hover_border' => 'hover:border-yellow-200',
                                            'hover_text' => 'group-hover/stat:text-yellow-600',
                                            'divider' => 'border-yellow-200/50',
                                            'level' => 'Average',
                                            'icon' => 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z'
                                        ];
                                    }
                                }
                            @endphp

                            <div class="mt-auto {{ $theme['bg'] }} rounded-2xl border-2 {{ $theme['border'] }} overflow-hidden animate-fade-in-up shadow-inner">
                                <div class="{{ $theme['header_bg'] }} px-5 py-4 border-b {{ $theme['header_border'] }} flex justify-between items-center">
                                    <div class="flex items-center gap-2">
                                        <div class="p-1 {{ $theme['icon_bg'] }} rounded-full">
                                            <svg class="w-4 h-4 {{ $theme['icon_text'] }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $theme['icon'] }}"></path>
                                            </svg>
                                        </div>
                                        <h4 class="font-bold {{ $theme['title'] }} text-sm tracking-wide uppercase">Analysis Result</h4>
                                    </div>
                                    <span class="text-xs font-mono {{ $theme['timestamp'] }} bg-white/50 px-2 py-1 rounded">{{ now()->format('h:i A') }}</span>
                                </div>
                                <div class="p-5">
                                    <!-- Big Score -->
                                    <div class="flex items-center justify-between mb-6">
                                        <div>
                                            <p class="text-xs text-gray-500 uppercase font-bold tracking-wider mb-1">Trust Score</p>
                                            <div class="flex items-baseline gap-1">
                                                <span class="text-4xl font-black {{ $theme['score'] }}">{{ $deliveryRate }}%</span>
                                                <span class="text-sm font-medium {{ $theme['sub_score'] }}">Success Rate</span>
                                            </div>
                                        </div>
                                        <div class="text-right">
                                            <span class="inline-block px-4 py-2 {{ $theme['badge'] }} text-white text-sm font-bold rounded-lg shadow-sm">
                                                {{ $theme['level'] }}
                                            </span>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-2 gap-3 mb-5">
                                        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 text-center group/stat {{ $theme['hover_border'] }} transition-colors">
                                            <p class="text-[10px] text-gray-400 uppercase font-bold tracking-widest mb-1">Total Orders</p>
                                            <p class="text-xl font-black text-gray-800 {{ $theme['hover_text'] }} transition-colors">{{ $total }}</p>
                                        </div>
                                        <div class="bg-white p-4 rounded-xl shadow-sm border border-gray-100 text-center group/stat {{ $theme['hover_border'] }} transition-colors">
                                            <p class="text-[10px] text-gray-400 uppercase font-bold tracking-widest mb-1">Mobile</p>
                                            <p class="text-sm font-bold text-gray-800 font-mono truncate {{ $theme['hover_text'] }} transition-colors" title="{{ session('fraud_result')['mobile_number'] ?? 'N/A' }}">
                                                {{ session('fraud_result')['mobile_number'] ?? 'N/A' }}
                                            </p>
                                        </div>
                                    </div>
                                    
                                    <div class="space-y-4">
                                        <!-- Progress Bar -->
                                        <div>
                                            <div class="flex justify-between text-xs mb-2 font-bold text-gray-600">
                                                <span>Success</span>
                                                <span>Return/Cancel</span>
                                            </div>
                                            <div class="w-full bg-white rounded-full h-3 overflow-hidden flex shadow-inner border border-gray-100">
                                                <div class="bg-gradient-to-r from-emerald-400 to-emerald-500 h-3 shadow-[0_0_10px_rgba(16,185,129,0.5)]" style="width: {{ $deliveryRate }}%"></div>
                                                <div class="bg-gradient-to-r from-red-400 to-red-500 h-3" style="width: {{ 100 - $deliveryRate }}%"></div>
                                            </div>
                                            <div class="flex justify-between text-[10px] mt-1.5 text-gray-400 font-medium">
                                                <span class="text-emerald-600">{{ $delivered }} Delivered</span>
                                                <span class="text-red-500">{{ $cancelled }} Cancelled</span>
                                            </div>
                                        </div>

                                        @if(isset(session('fraud_result')['apis']))
                                            <div class="pt-4 border-t {{ $theme['divider'] }}">
                                                <p class="text-[10px] font-bold text-gray-400 mb-3 uppercase tracking-widest">Courier History</p>
                                                <div class="space-y-2 max-h-40 overflow-y-auto pr-2 scrollbar-thin scrollbar-thumb-gray-200 scrollbar-track-transparent">
                                                    @foreach(session('fraud_result')['apis'] as $courier => $data)
                                                        <div class="flex justify-between items-center text-xs bg-white p-2.5 rounded-lg border border-gray-100 shadow-sm hover:shadow-md transition-shadow">
                                                            <div class="flex items-center gap-2">
                                                                <div class="w-1.5 h-1.5 rounded-full bg-gray-300"></div>
                                                                <span class="font-bold text-gray-700 uppercase">{{ $courier }}</span>
                                                            </div>
                                                            <div class="flex space-x-1.5">
                                                                <span class="px-2 py-0.5 bg-green-50 text-green-700 rounded border border-green-100 font-bold text-[10px]">Del: {{ $data['total_delivered_parcels'] ?? 0 }}</span>
                                                                <span class="px-2 py-0.5 bg-red-50 text-red-700 rounded border border-red-100 font-bold text-[10px]">Can: {{ $data['total_cancelled_parcels'] ?? 0 }}</span>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="mt-auto flex flex-col items-center justify-center p-12 text-center text-gray-400 border-2 border-dashed border-gray-200 rounded-2xl bg-gray-50/50 hover:bg-gray-50 transition-colors">
                                <div class="bg-white p-4 rounded-full shadow-sm mb-4">
                                    <svg class="w-8 h-8 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                                <h4 class="text-gray-900 font-medium mb-1">No Analysis Yet</h4>
                                <span class="text-sm text-gray-500 max-w-[200px]">Enter a phone number above to check fraud status</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .animate-fade-in-down {
            animation: fadeInDown 0.6s cubic-bezier(0.16, 1, 0.3, 1);
        }
        .animate-fade-in-up {
            animation: fadeInUp 0.6s cubic-bezier(0.16, 1, 0.3, 1);
        }
        .animate-blob {
            animation: blob 7s infinite;
        }
        .animation-delay-2000 {
            animation-delay: 2s;
        }
        .animation-delay-4000 {
            animation-delay: 4s;
        }
        .animate-spin-slow {
            animation: spin 3s linear infinite;
        }
        
        @keyframes fadeInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes fadeInUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes blob {
            0% { transform: translate(0px, 0px) scale(1); }
            33% { transform: translate(30px, -50px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
            100% { transform: translate(0px, 0px) scale(1); }
        }
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</x-admin-layout>