<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Courier API Settings') }}
        </h2>
    </x-slot>

    <div class="py-6" x-data="{ showModal: {{ $errors->any() ? 'true' : 'false' }} }">
        <style>
            @keyframes slideInUp {
                from { opacity: 0; transform: translateY(20px); }
                to { opacity: 1; transform: translateY(0); }
            }
            .animate-slide-up {
                animation: slideInUp 0.5s ease-out forwards;
            }
            .animation-delay-100 { animation-delay: 0.1s; }
            .animation-delay-200 { animation-delay: 0.2s; }
            .animation-delay-300 { animation-delay: 0.3s; }
            [x-cloak] { display: none !important; }
        </style>
        <div class="w-full space-y-6 px-4 sm:px-6 lg:px-8">
            
            @if (session('success'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Success</p>
                    <p>{{ session('success') }}</p>
                </div>
            @endif

            @if (session('error'))
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm animate-slide-up" role="alert">
                    <p class="font-bold">Error</p>
                    <p>{{ session('error') }}</p>
                </div>
            @endif

            <!-- Steadfast Courier Section -->
            <div class="bg-white rounded-3xl shadow-sm border border-gray-200 p-6 sm:p-8">
                <!-- Section Header -->
                <div class="flex items-center space-x-3 mb-6">
                     <div class="p-2.5 bg-teal-50 rounded-xl border border-teal-100">
                         <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-teal-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                             <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                         </svg>
                     </div>
                     <div>
                         <h3 class="text-lg font-bold text-gray-800">Steadfast Courier Data</h3>
                         <p class="text-xs text-gray-500">Real-time shipping metrics & integration status</p>
                     </div>
                </div>

                <!-- Main Grid Container: 4 Columns in one row -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    
                    <!-- 1. Steadfast Balance -->
                    <div class="bg-gradient-to-br from-green-600 to-teal-700 rounded-2xl shadow-lg border border-teal-500/30 relative overflow-hidden group hover:shadow-xl transition-all duration-300 transform hover:-translate-y-1 animate-slide-up">
                        <div class="absolute top-0 right-0 -mt-4 -mr-4 w-24 h-24 rounded-full bg-white opacity-10 blur-xl group-hover:scale-110 transition-transform duration-500"></div>
                        <div class="p-6 flex flex-col justify-between h-full relative z-10">
                            <div class="flex items-center space-x-3 mb-2">
                                <div class="bg-white/20 p-2 rounded-lg backdrop-blur-md">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <h3 class="text-teal-100 font-medium text-sm">Steadfast Balance</h3>
                            </div>
                            <div>
                                <div class="text-3xl font-bold tracking-tight text-white drop-shadow-sm">
                                    @if(isset($steadfastBalance) && $steadfastBalance !== null)
                                        ৳ {{ number_format($steadfastBalance, 2) }}
                                    @else
                                        <span class="text-xl text-teal-200">N/A</span>
                                    @endif
                                </div>
                                @if(!isset($steadfastBalance) || $steadfastBalance === null)
                                    <p class="text-xs text-teal-200 opacity-80 mt-1">Not connected</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- 2. Pending Deliveries -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6 relative overflow-hidden group hover:shadow-xl transition-all duration-300 animate-slide-up animation-delay-100">
                        <div class="flex flex-col justify-between h-full">
                            <div class="flex items-center justify-between mb-2">
                                <h3 class="text-sm font-bold text-gray-500 uppercase tracking-wider">Pending Parcels</h3>
                                <span class="bg-orange-100 text-orange-600 p-1.5 rounded-lg">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                    </svg>
                                </span>
                            </div>
                            <div class="flex items-baseline">
                                <span class="text-3xl font-extrabold text-gray-900">{{ $pendingDeliveries ?? 0 }}</span>
                                <span class="ml-2 text-xs text-gray-400">Not Delivered</span>
                            </div>
                        </div>
                    </div>

                    <!-- 3. Order Statistics -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-5 relative overflow-hidden group hover:shadow-xl transition-all duration-300 animate-slide-up animation-delay-200">
                        <h3 class="text-sm font-bold text-gray-500 uppercase tracking-wider mb-3">Order Statistics <span class="normal-case font-normal text-gray-400 text-xs ml-1">(Last Entries)</span></h3>
                        <div class="space-y-2">
                            <!-- Pending -->
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-2 h-2 rounded-full bg-yellow-400 mr-2"></div>
                                    <span class="text-xs text-gray-600">Pending</span>
                                </div>
                                <span class="text-sm font-bold text-gray-800">{{ $orderStats['pending'] ?? 0 }}</span>
                            </div>
                            <!-- Delivered -->
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-2 h-2 rounded-full bg-green-500 mr-2"></div>
                                    <span class="text-xs text-gray-600">Delivered</span>
                                </div>
                                <span class="text-sm font-bold text-gray-800">{{ $orderStats['delivered'] ?? 0 }}</span>
                            </div>
                            <!-- Cancelled -->
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-2 h-2 rounded-full bg-red-500 mr-2"></div>
                                    <span class="text-xs text-gray-600">Cancelled</span>
                                </div>
                                <span class="text-sm font-bold text-gray-800">{{ $orderStats['cancelled'] ?? 0 }}</span>
                            </div>
                        </div>
                    </div>

                    <!-- 4. Steadfast Courier Settings -->
                    <div class="bg-white rounded-2xl shadow-lg border border-gray-100 p-6 relative overflow-hidden group hover:shadow-xl transition-all duration-300 animate-slide-up animation-delay-300 flex flex-col justify-center items-center text-center">
                         <!-- Top Gradient Border -->
                         <div class="absolute top-0 left-0 right-0 h-1 bg-gradient-to-r from-green-500 via-teal-500 to-cyan-500"></div>
                         
                         <div class="mb-3 bg-teal-50 p-3 rounded-full border border-teal-100">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-teal-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                            </svg>
                         </div>
                         
                         <h3 class="text-lg font-bold text-gray-800 mb-1">Steadfast Courier</h3>
                         
                         <div class="mb-4">
                            @if($setting->courier_steadfast_enabled ?? false)
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800">
                                    <span class="w-1.5 h-1.5 bg-green-500 rounded-full mr-1.5 animate-pulse"></span>
                                    Active
                                </span>
                            @else
                                <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-600">
                                    Inactive
                                </span>
                            @endif
                         </div>

                         <button @click="showModal = true" 
                                class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-lg font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z" />
                            </svg>
                            Configure
                         </button>
                    </div>

                </div>
            </div>
        </div>

        <!-- Modal -->
        <div x-cloak x-show="showModal" class="fixed z-50 inset-0 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0" 
                     x-transition:enter-end="opacity-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100" 
                     x-transition:leave-end="opacity-0" 
                     class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                     @click="showModal = false"
                     aria-hidden="true"></div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg w-full">
                    
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="sm:flex sm:items-start">
                            <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-teal-100 sm:mx-0 sm:h-10 sm:w-10">
                                <svg class="h-6 w-6 text-teal-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                </svg>
                            </div>
                            <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                                <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                                    Steadfast Courier Integration
                                </h3>
                                <div class="mt-2">
                                    <p class="text-sm text-gray-500 mb-4">
                                        Enter your API credentials to connect with Steadfast Courier.
                                    </p>
                                    
                                    <form id="courierForm" action="{{ route('admin.api.courier.update') }}" method="POST">
                                        @csrf
                                        
                                        <div class="space-y-4">
                                            <!-- Base URL (Read Only) -->
                                            <div>
                                                 <label class="block text-sm font-medium text-gray-700 mb-1">API Base URL</label>
                                                 <input type="text" value="https://portal.packzy.com/api/v1" disabled class="block w-full px-3 py-2 bg-gray-50 border border-gray-300 rounded-md text-gray-500 text-sm focus:outline-none">
                                            </div>

                                            <!-- API Key -->
                                            <div>
                                                <label for="courier_steadfast_api_key" class="block text-sm font-medium text-gray-700 mb-1">API Key <span class="text-red-500">*</span></label>
                                                <input type="text" name="courier_steadfast_api_key" id="courier_steadfast_api_key" value="{{ old('courier_steadfast_api_key', $setting->courier_steadfast_api_key ?? '') }}" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-teal-500 focus:border-teal-500 sm:text-sm" placeholder="Enter API Key">
                                            </div>

                                            <!-- Secret Key -->
                                            <div>
                                                <label for="courier_steadfast_secret_key" class="block text-sm font-medium text-gray-700 mb-1">Secret Key <span class="text-red-500">*</span></label>
                                                <input type="text" name="courier_steadfast_secret_key" id="courier_steadfast_secret_key" value="{{ old('courier_steadfast_secret_key', $setting->courier_steadfast_secret_key ?? '') }}" class="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-teal-500 focus:border-teal-500 sm:text-sm" placeholder="Enter Secret Key">
                                            </div>

                                            <!-- Enable/Disable Switch -->
                                            <div class="flex items-center justify-between bg-gray-50 p-3 rounded-lg border border-gray-200">
                                                <span class="text-sm font-medium text-gray-700">Enable Integration</span>
                                                <label class="relative inline-flex items-center cursor-pointer">
                                                    <input type="checkbox" name="courier_steadfast_enabled" value="1" class="sr-only peer" {{ ($setting->courier_steadfast_enabled ?? false) ? 'checked' : '' }}>
                                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-teal-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-teal-600"></div>
                                                </label>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="submit" form="courierForm" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-teal-600 text-base font-medium text-white hover:bg-teal-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-teal-500 sm:ml-3 sm:w-auto sm:text-sm">
                            Save Changes
                        </button>
                        <button type="button" @click="showModal = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-teal-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Cancel
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>