<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Auto Call API') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">
            @if (session('success'))
                <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded shadow-sm" role="alert">
                    <p class="font-bold">Success</p>
                    <p>{{ session('success') }}</p>
                </div>
            @endif
            @if (session('error'))
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded shadow-sm" role="alert">
                    <p class="font-bold">Error</p>
                    <p>{{ session('error') }}</p>
                </div>
            @endif

            <!-- Settings -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-2xl border border-gray-100">
                <div class="p-6">
                    <div class="mb-4">
                        <h3 class="text-lg font-bold text-gray-800">Auto Call Settings (Twilio)</h3>
                        <p class="text-sm text-gray-500">Twilio credentials & call-center number</p>
                    </div>
                    <form action="{{ route('admin.api.auto_call.update') }}" method="POST" class="space-y-4">
                        @csrf
                        <div class="flex items-center gap-3">
                            <input type="checkbox" name="auto_call_enabled" id="auto_call_enabled" class="h-4 w-4 text-indigo-600 border-gray-300 rounded" {{ old('auto_call_enabled', $setting->auto_call_enabled ?? false) ? 'checked' : '' }}>
                            <label for="auto_call_enabled" class="text-sm font-medium text-gray-700">Enable Auto Call</label>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Twilio Account SID</label>
                                <input type="text" name="twilio_account_sid" value="{{ old('twilio_account_sid', $setting->twilio_account_sid ?? '') }}" class="w-full border-gray-300 rounded-lg">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Twilio Auth Token</label>
                                <input type="password" name="twilio_auth_token" value="{{ old('twilio_auth_token', $setting->twilio_auth_token ?? '') }}" class="w-full border-gray-300 rounded-lg">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Twilio Phone Number</label>
                                <input type="text" name="twilio_phone_number" value="{{ old('twilio_phone_number', $setting->twilio_phone_number ?? '') }}" class="w-full border-gray-300 rounded-lg" placeholder="+1xxxxxxxxxx">
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-1">Call Center Number</label>
                                <input type="text" name="call_center_number" value="{{ old('call_center_number', $setting->call_center_number ?? '') }}" class="w-full border-gray-300 rounded-lg" placeholder="+8801XXXXXXXXX">
                            </div>
                        </div>
                        <div>
                            <button type="submit" class="px-5 py-2.5 bg-gray-900 text-white rounded-lg hover:bg-gray-800">Save Settings</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Test Call -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-2xl border border-gray-100">
                <div class="p-6">
                    <div class="mb-4">
                        <h3 class="text-lg font-bold text-gray-800">Test Auto Call</h3>
                        <p class="text-sm text-gray-500">Initiate a test call for any order</p>
                    </div>
                    <div class="bg-yellow-50 border border-yellow-200 text-yellow-800 rounded-lg p-3 text-sm mb-4">
                        Ensure your APP_URL points to a public URL (e.g., via ngrok) so Twilio can reach webhooks.
                    </div>
                    <form action="{{ route('admin.api.auto_call.test') }}" method="POST" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Order ID</label>
                            <input type="number" name="order_id" class="w-full border-gray-300 rounded-lg" placeholder="e.g. 123">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Customer Phone</label>
                            <input type="text" name="phone" class="w-full border-gray-300 rounded-lg" placeholder="+8801XXXXXXXXX">
                        </div>
                        <div class="flex items-end">
                            <button type="submit" class="px-5 py-2.5 bg-indigo-600 text-white rounded-lg hover:bg-indigo-500 w-full">Start Test Call</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
