<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Create Permissions
        $permissions = [
            'dashboard.view',
            
            // Orders
            'orders.view',
            'orders.update_status',
            'orders.manage',

            // Products
            'products.view',
            'products.create',
            'products.edit',
            'products.delete',
            
            // Attributes
            'categories.manage',
            'subcategories.manage',
            'childcategories.manage',
            'brands.manage',
            'colors.manage',
            'sizes.manage',

            // Reviews
            'reviews.manage',

            // Landing Pages
            'landing_pages.manage',
            'campaigns.manage',

            // Users
            'users.manage',
            'roles.manage',
            'permissions.manage',
            'customers.manage',

            // Settings
            'settings.manage',
            'pages.manage',

            // API
            'api.manage',

            // Pixels
            'pixels.manage',

            // Banners
            'banners.manage',

            // Reports
            'reports.view',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create Roles and Assign Permissions
        
        // Super Admin
        $superAdmin = Role::firstOrCreate(['name' => 'Super Admin']);
        $superAdmin->givePermissionTo(Permission::all());

        // Admin
        $admin = Role::firstOrCreate(['name' => 'Admin']);
        $admin->givePermissionTo([
            'dashboard.view',
            'orders.view', 'orders.update_status', 'orders.manage',
            'products.view', 'products.create', 'products.edit', 'products.delete',
            'categories.manage', 'subcategories.manage', 'childcategories.manage',
            'brands.manage', 'colors.manage', 'sizes.manage',
            'reviews.manage',
            'landing_pages.manage', 'campaigns.manage',
            'customers.manage',
            'banners.manage',
            'reports.view',
            'settings.manage',
            'pages.manage',
        ]);

        // Staff
        $staff = Role::firstOrCreate(['name' => 'Staff']);
        $staff->givePermissionTo([
            'dashboard.view',
            'orders.view', 'orders.update_status',
            'products.view',
            'reviews.manage',
        ]);

        // Customer
        $customer = Role::firstOrCreate(['name' => 'Customer']);
    }
}
