<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Models\Product;
use App\Models\ProductImage;
use App\Models\ProductVariant;

class CloneShoesSeeder extends Seeder
{
    public function run(): void
    {
        $original = Product::where('slug', 'shoes')->with(['images', 'variants'])->first();
        if (!$original) {
            echo "Original product 'shoes' not found.\n";
            return;
        }

        for ($i = 1; $i <= 10; $i++) {
            DB::transaction(function () use ($original, $i) {
                $copy = $original->replicate();

                $base = Str::slug($original->slug ?: $original->name);
                $suffix = $i;
                $slug = "{$base}-{$suffix}";
                while (Product::where('slug', $slug)->exists()) {
                    $suffix++;
                    $slug = "{$base}-{$suffix}";
                }
                $copy->slug = $slug;

                if (!empty($original->sku)) {
                    $skuBase = $original->sku;
                    $sku = $skuBase . '-' . strtoupper(Str::random(4));
                    while (Product::where('sku', $sku)->exists()) {
                        $sku = $skuBase . '-' . strtoupper(Str::random(4));
                    }
                    $copy->sku = $sku;
                }

                $copy->save();

                foreach ($original->images as $img) {
                    ProductImage::create([
                        'product_id' => $copy->id,
                        'image_path' => $img->image_path,
                    ]);
                }

                foreach ($original->variants as $v) {
                    ProductVariant::create([
                        'product_id' => $copy->id,
                        'size_id' => $v->size_id,
                        'color_id' => $v->color_id,
                        'price' => $v->price,
                        'offer_price' => $v->offer_price,
                        'stock_quantity' => $v->stock_quantity,
                        'discount_type' => $v->discount_type,
                        'discount_value' => $v->discount_value,
                        'inventory_status' => $v->inventory_status,
                        'weight' => $v->weight,
                        'weight_unit' => $v->weight_unit,
                        'description' => $v->description,
                        'visibility' => $v->visibility,
                        'delivery_type' => $v->delivery_type,
                        'image' => $v->image,
                    ]);
                }
            });
        }
    }
}
