<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('capi_logs', function (Blueprint $table) {
            $table->id();
            $table->string('pixel_id');
            $table->string('event_name');
            $table->string('event_id')->nullable();
            $table->string('status');
            $table->integer('response_code')->nullable();
            $table->text('response_body')->nullable();
            $table->json('payload')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('capi_logs');
    }
};
