<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('facebook_pixels', function (Blueprint $table) {
            $table->string('api_version')->default('v19.0')->after('test_event_code');
            $table->boolean('server_side_enabled')->default(true)->after('api_version');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('facebook_pixels', function (Blueprint $table) {
            $table->dropColumn(['api_version', 'server_side_enabled']);
        });
    }
};
