<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('order_calls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete('cascade');
            $table->string('call_sid')->nullable()->index();
            $table->unsignedInteger('attempt')->default(1);
            $table->unsignedInteger('duration')->nullable();
            $table->string('dtmf_input')->nullable();
            $table->string('call_result')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_calls');
    }
};
