<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            if (!Schema::hasColumn('general_settings', 'auto_call_enabled')) {
                $table->boolean('auto_call_enabled')->default(false)->after('status');
            }
            if (!Schema::hasColumn('general_settings', 'twilio_account_sid')) {
                $table->string('twilio_account_sid')->nullable()->after('auto_call_enabled');
            }
            if (!Schema::hasColumn('general_settings', 'twilio_auth_token')) {
                $table->string('twilio_auth_token')->nullable()->after('twilio_account_sid');
            }
            if (!Schema::hasColumn('general_settings', 'twilio_phone_number')) {
                $table->string('twilio_phone_number')->nullable()->after('twilio_auth_token');
            }
            if (!Schema::hasColumn('general_settings', 'call_center_number')) {
                $table->string('call_center_number')->nullable()->after('twilio_phone_number');
            }
        });
    }

    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            if (Schema::hasColumn('general_settings', 'auto_call_enabled')) {
                $table->dropColumn('auto_call_enabled');
            }
            if (Schema::hasColumn('general_settings', 'twilio_account_sid')) {
                $table->dropColumn('twilio_account_sid');
            }
            if (Schema::hasColumn('general_settings', 'twilio_auth_token')) {
                $table->dropColumn('twilio_auth_token');
            }
            if (Schema::hasColumn('general_settings', 'twilio_phone_number')) {
                $table->dropColumn('twilio_phone_number');
            }
            if (Schema::hasColumn('general_settings', 'call_center_number')) {
                $table->dropColumn('call_center_number');
            }
        });
    }
};
