<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('product_variants', function (Blueprint $table) {
            if (!Schema::hasColumn('product_variants', 'offer_price')) {
                $table->decimal('offer_price', 10, 2)->nullable()->after('price');
            }
            if (!Schema::hasColumn('product_variants', 'discount_type')) {
                $table->string('discount_type')->nullable()->after('offer_price');
            }
            if (!Schema::hasColumn('product_variants', 'discount_value')) {
                $table->decimal('discount_value', 10, 2)->default(0)->after('discount_type');
            }
            if (!Schema::hasColumn('product_variants', 'inventory_status')) {
                $table->string('inventory_status')->default('in_stock')->after('stock_quantity');
            }
            if (!Schema::hasColumn('product_variants', 'weight')) {
                $table->decimal('weight', 8, 2)->default(0)->after('inventory_status');
            }
            if (!Schema::hasColumn('product_variants', 'weight_unit')) {
                $table->string('weight_unit')->default('kg')->after('weight');
            }
            if (!Schema::hasColumn('product_variants', 'description')) {
                $table->text('description')->nullable()->after('weight_unit');
            }
            if (!Schema::hasColumn('product_variants', 'visibility')) {
                $table->boolean('visibility')->default(1)->after('description');
            }
            if (!Schema::hasColumn('product_variants', 'delivery_type')) {
                $table->string('delivery_type')->default('flat_rate')->after('visibility');
            }
            if (!Schema::hasColumn('product_variants', 'image')) {
                $table->string('image')->nullable()->after('delivery_type');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('product_variants', function (Blueprint $table) {
            $table->dropColumn([
                'offer_price',
                'discount_type',
                'discount_value',
                'inventory_status',
                'weight',
                'weight_unit',
                'description',
                'visibility',
                'delivery_type',
                'image',
            ]);
        });
    }
};