<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('facebook_pixel_enabled')->default(false)->after('google_verification_code');
            $table->string('facebook_pixel_id')->nullable()->after('facebook_pixel_enabled');
            $table->text('facebook_access_token')->nullable()->after('facebook_pixel_id');
            $table->string('facebook_test_event_code')->nullable()->after('facebook_access_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'facebook_pixel_enabled',
                'facebook_pixel_id',
                'facebook_access_token',
                'facebook_test_event_code',
            ]);
        });
    }
};
