<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            // bKash
            $table->boolean('bkash_enabled')->default(false);
            $table->string('bkash_app_key')->nullable();
            $table->string('bkash_app_secret')->nullable();
            $table->string('bkash_username')->nullable();
            $table->string('bkash_password')->nullable();
            $table->boolean('bkash_test_mode')->default(true);

            // SSLCommerz
            $table->boolean('sslcz_enabled')->default(false);
            $table->string('sslcz_store_id')->nullable();
            $table->string('sslcz_store_password')->nullable();
            $table->boolean('sslcz_test_mode')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'bkash_enabled',
                'bkash_app_key',
                'bkash_app_secret',
                'bkash_username',
                'bkash_password',
                'bkash_test_mode',
                'sslcz_enabled',
                'sslcz_store_id',
                'sslcz_store_password',
                'sslcz_test_mode',
            ]);
        });
    }
};
