<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('courier_steadfast_enabled')->default(false)->after('sms_password_generator');
            $table->string('courier_steadfast_api_key')->nullable()->after('courier_steadfast_enabled');
            $table->string('courier_steadfast_secret_key')->nullable()->after('courier_steadfast_api_key');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn([
                'courier_steadfast_enabled',
                'courier_steadfast_api_key',
                'courier_steadfast_secret_key',
            ]);
        });
    }
};
