<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->boolean('sms_active')->default(false)->after('sms_api_key');
            $table->boolean('sms_order_confirm')->default(false)->after('sms_active');
            $table->boolean('sms_forgot_password')->default(false)->after('sms_order_confirm');
            $table->boolean('sms_password_generator')->default(false)->after('sms_forgot_password');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('general_settings', function (Blueprint $table) {
            $table->dropColumn(['sms_active', 'sms_order_confirm', 'sms_forgot_password', 'sms_password_generator']);
        });
    }
};
