<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            if (!Schema::hasColumn('orders', 'fraud_score')) {
                $table->integer('fraud_score')->nullable()->after('status');
            }
            if (!Schema::hasColumn('orders', 'fraud_data')) {
                $table->json('fraud_data')->nullable()->after('fraud_score');
            }
            if (!Schema::hasColumn('orders', 'fraud_checked_at')) {
                $table->timestamp('fraud_checked_at')->nullable()->after('fraud_data');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['fraud_score', 'fraud_data', 'fraud_checked_at']);
        });
    }
};
