<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipping_charges', function (Blueprint $table) {
            $table->dropColumn('amount');
            $table->decimal('charge_0_0_5', 8, 2)->default(0); // 0 to 0.5 kg
            $table->decimal('charge_0_5_1', 8, 2)->default(0); // 0.5 to 1 kg
            $table->decimal('charge_1_2', 8, 2)->default(0);   // 1 to 2 kg
            $table->decimal('charge_over_2', 8, 2)->default(0); // Over 2 kg per kg
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shipping_charges', function (Blueprint $table) {
            $table->decimal('amount', 8, 2)->default(0);
            $table->dropColumn(['charge_0_0_5', 'charge_0_5_1', 'charge_1_2', 'charge_over_2']);
        });
    }
};
