<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_settings', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('facebook_verification_code')->nullable();
            $table->string('google_verification_code')->nullable();
            $table->string('white_logo')->nullable();
            $table->string('dark_logo')->nullable();
            $table->string('favicon')->nullable();
            $table->string('og_banner_image')->nullable();
            $table->date('hot_deal_end_date')->nullable();
            $table->date('flash_sale_end_date')->nullable();
            $table->text('header_code')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keyword')->nullable();
            $table->text('top_headline')->nullable();
            $table->longText('checkout_note')->nullable();
            $table->longText('order_policy')->nullable();
            $table->boolean('all_products_at_home')->default(false);
            $table->boolean('categories_wise_products_at_home')->default(false);
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_settings');
    }
};
