<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->string('delivery_area')->nullable();
            $table->string('district')->nullable();
            $table->string('thana')->nullable();
            $table->decimal('advance_amount', 10, 2)->default(0);
            $table->string('payment_sender_number')->nullable();
            $table->string('payment_receiver_number')->nullable();
            $table->text('note')->nullable(); // Customer Note
            $table->text('staff_note')->nullable(); // Office Note
            $table->decimal('extra_charge', 10, 2)->default(0);
            $table->decimal('discount_amount', 10, 2)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn([
                'delivery_area',
                'district',
                'thana',
                'advance_amount',
                'payment_sender_number',
                'payment_receiver_number',
                'note',
                'staff_note',
                'extra_charge',
                'discount_amount',
            ]);
        });
    }
};
