<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->string('sku')->nullable()->after('name');
            $table->string('unit')->nullable()->after('stock_quantity');
            $table->string('unit_value')->nullable()->after('unit');
            $table->decimal('weight', 10, 2)->nullable()->after('unit_value');
            $table->string('weight_unit')->nullable()->after('weight');
            $table->boolean('pre_order')->default(false)->after('status');
            $table->string('condition')->default('new')->after('pre_order');
            $table->string('availability')->default('in_stock')->after('condition');
            $table->string('discount_type')->nullable()->after('offer_price');
            $table->decimal('discount_value', 10, 2)->nullable()->after('discount_type');
            $table->integer('stock_alert')->nullable()->after('stock_quantity');
            $table->text('video_embed')->nullable()->after('short_description');
            $table->string('video_position')->nullable()->after('video_embed');
            $table->string('delivery_type')->default('flat_rate')->after('weight_unit');
            $table->boolean('is_digital')->default(false)->after('pre_order');
            $table->boolean('has_seo')->default(false)->after('meta_description');
            $table->boolean('offer_1')->default(false)->after('is_featured');
            $table->boolean('offer_2')->default(false)->after('offer_1');
            $table->boolean('offer_3')->default(false)->after('offer_2');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            $table->dropColumn([
                'sku', 'unit', 'unit_value', 'weight', 'weight_unit', 
                'pre_order', 'condition', 'availability', 'discount_type', 
                'discount_value', 'stock_alert', 'video_embed', 'video_position', 
                'delivery_type', 'is_digital', 'has_seo', 'offer_1', 'offer_2', 'offer_3'
            ]);
        });
    }
};
