<?php

namespace App\Services;

use App\Models\GeneralSetting;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class SmsService
{
    public function send($phone, $message)
    {
        $setting = GeneralSetting::first();
        
        // Check if SMS is globally active and API key exists
        if (!$setting || !$setting->sms_api_key || !$setting->sms_active) {
            return false;
        }

        try {
            $response = Http::get('https://fraudchecker.link/api/v1/sms/', [
                'api_key' => $setting->sms_api_key,
                'number' => $phone,
                'message' => $message,
            ]);

            $result = $response->json();
            
            // Log success or failure from API response if needed
            if (isset($result['status']) && $result['status'] != 'success') {
                 Log::warning('SMS API Error: ' . ($result['message'] ?? 'Unknown'));
            }

            return $result;
        } catch (\Exception $e) {
            Log::error('SMS Send Exception: ' . $e->getMessage());
            return false;
        }
    }

    public function sendOrderConfirmation($order)
    {
        $setting = GeneralSetting::first();
        
        // Check if Order Confirmation SMS is enabled
        if (!$setting || !$setting->sms_order_confirm) {
            return;
        }

        $shopName = $setting->name ?? config('app.name');
        
        if ($order->payment_method == 'cod') {
            $message = "প্রিয় গ্রাহক, আপনার Cash on Delivery অর্ডারটি সফলভাবে গ্রহণ করা হয়েছে। Order ID: {$order->order_number} ডেলিভারির সময় পেমেন্ট করবেন। ধন্যবাদান্তে, {$shopName}";
        } else {
            $message = "Order Placed: Your order #{$order->order_number} has been received. Total: {$order->total_amount} TK. We will contact you soon. - {$shopName}";
        }
        
        return $this->send($order->phone, $message);
    }
}
