<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\GeneralSetting;
use App\Models\Category;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        try {
            if (Schema::hasTable('general_settings')) {
                $generalSetting = GeneralSetting::first();
                View::share('generalSetting', $generalSetting);
            }
            if (Schema::hasTable('categories')) {
                $globalCategories = Category::whereNull('parent_id')->with('children')->get();
                View::share('globalCategories', $globalCategories);
            }
            if (Schema::hasTable('facebook_pixels')) {
                $facebookPixels = \App\Models\FacebookPixel::where('is_active', true)->get();
                if ($facebookPixels->isEmpty() && Schema::hasTable('general_settings')) {
                    $setting = GeneralSetting::first();
                    if ($setting && $setting->facebook_pixel_enabled && $setting->facebook_pixel_id) {
                         $facebookPixels->push((object)[
                            'pixel_id' => $setting->facebook_pixel_id,
                            'access_token' => $setting->facebook_access_token,
                            'test_event_code' => $setting->facebook_test_event_code ?? null,
                            'api_version' => 'v19.0'
                        ]);
                    }
                }
                View::share('facebookPixels', $facebookPixels);
            }
            if (Schema::hasTable('gtm_containers')) {
                $gtmContainers = \App\Models\GtmContainer::where('is_active', true)->get();
                View::share('gtmContainers', $gtmContainers);
            }
            if (Schema::hasTable('tiktok_pixels')) {
                $tiktokPixels = \App\Models\TiktokPixel::where('is_active', true)->get();
                View::share('tiktokPixels', $tiktokPixels);
            }
            if (Schema::hasTable('contact_settings')) {
                $contactSetting = \App\Models\ContactSetting::first();
                View::share('contactSetting', $contactSetting);
            }
            if (Schema::hasTable('social_medias')) {
                $socialMedias = \App\Models\SocialMedia::where('status', true)->get();
                View::share('socialMedias', $socialMedias);
            }
        } catch (\Exception $e) {
            // Log the error or ignore it during boot if DB is not ready
            \Log::error('AppServiceProvider boot failed to load settings: ' . $e->getMessage());
        }
    }
}
