<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'sku',
        'thumbnail',
        'category_id',
        'brand_id',
        'description',
        'short_description',
        'price',
        'offer_price',
        'discount_type',
        'discount_value',
        'stock_quantity',
        'stock_alert',
        'unit',
        'unit_value',
        'weight',
        'weight_unit',
        'delivery_type',
        'video_embed',
        'video_position',
        'is_featured',
        'status',
        'pre_order',
        'condition',
        'availability',
        'is_digital',
        'has_seo',
        'offer_1',
        'offer_2',
        'offer_3',
        'meta_title',
        'meta_description',
        'purchase_price',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function images()
    {
        return $this->hasMany(ProductImage::class);
    }

    public function variants()
    {
        return $this->hasMany(ProductVariant::class);
    }

    public function colors()
    {
        return $this->belongsToMany(Color::class, 'product_variants', 'product_id', 'color_id')->distinct();
    }

    public function sizes()
    {
        return $this->belongsToMany(Size::class, 'product_variants', 'product_id', 'size_id')->distinct();
    }

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }
}
