<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'order_number',
        'first_name',
        'last_name',
        'email',
        'phone',
        'address',
        'city',
        'postal_code',
        'total_amount',
        'status',
        'source',
        'is_from_incomplete',
        'payment_method',
        'payment_status',
        'delivery_area',
        'district',
        'thana',
        'attachment',
        'advance_amount',
        'payment_sender_number',
        'payment_receiver_number',
        'note',
        'staff_note',
        'extra_charge',
        'discount_amount',
        'delivery_cost',
        'fraud_score',
        'fraud_data',
        'fraud_checked_at',
        'courier_name',
        'courier_consignment_id',
        'courier_tracking_id',
        'courier_status',
    ];

    protected $casts = [
        'fraud_data' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function calls()
    {
        return $this->hasMany(\App\Models\OrderCall::class);
    }
}
