<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FacebookPixel extends Model
{
    use HasFactory;

    protected $fillable = [
        'pixel_id',
        'catalog_id',
        'access_token',
        'test_event_code',
        'api_version',
        'server_side_enabled',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'server_side_enabled' => 'boolean',
        'access_token' => 'encrypted',
    ];
}
