<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    use HasFactory;

    protected $fillable = [
        'banner_category_id',
        'product_category_id',
        'title',
        'subtitle',
        'text_position',
        'image',
        'url',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
    ];

    public function category()
    {
        return $this->belongsTo(BannerCategory::class, 'banner_category_id');
    }

    public function productCategory()
    {
        return $this->belongsTo(Category::class, 'product_category_id');
    }
}
