<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

use Illuminate\Support\Facades\Cookie;

class CaptureTiktokClickId
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->has('ttclid')) {
            $ttclid = $request->input('ttclid');
            session(['ttclid' => $ttclid]);
            Cookie::queue('ttclid', $ttclid, 60 * 24 * 7); // 7 days
        }

        return $next($request);
    }
}
