<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\LandingPage;
use App\Models\Category;
use App\Models\Product;
use App\Models\GeneralSetting;
use App\Models\Banner;
use App\Models\ContactSetting;

class HomeController extends Controller
{
    /**
     * Show the application dashboard or home page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        // Check if there is a landing page set as home
        $landingPage = LandingPage::where('is_home', true)
            ->where('status', 'active')
            ->with('product')
            ->first();

        if ($landingPage) {
            return view('frontend.landing_pages.show', compact('landingPage'));
        }

        // Default home page if no landing page is set as home
        if (view()->exists('frontend.home')) {
            $categories = Category::all();
            $featuredProducts = Product::where('is_featured', true)->take(8)->get();
            $newArrivals = Product::latest()->take(8)->get();
            $allProducts = Product::where('status', true)->latest()->take(30)->get();
            $generalSetting = GeneralSetting::first();
            
            // Fetch active banners (Assuming 'home' category or general active banners)
            // If we want to be specific, we could add a scope or filter by category slug 'home'
            // For now, let's just get the latest active banner(s)
            $banners = Banner::where('status', true)->with('category')->latest()->get();

            return view('frontend.home', compact('categories', 'featuredProducts', 'newArrivals', 'allProducts', 'generalSetting', 'banners'));
        }
        
        return view('welcome');
    }

    /**
     * Show the contact page.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function contact()
    {
        $contactSetting = ContactSetting::where('status', true)->first();
        return view('frontend.contact', compact('contactSetting'));
    }

    /**
     * Show a static page.
     *
     * @param string $slug
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function page($slug)
    {
        // This is a placeholder for static pages.
        // You can implement logic to fetch page content from database here.
        abort(404);
    }
}
