<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;

class OrderTrackingController extends Controller
{
    public function index()
    {
        return view('frontend.order_tracking.index');
    }

    public function track(Request $request)
    {
        $request->validate([
            'track_code' => 'required|string',
        ], [
            'track_code.required' => 'অর্ডার আইডি অথবা ফোন নাম্বার দিন',
        ]);

        $code = $request->track_code;

        // Search by ID, Order Number or Phone
        $order = Order::where('id', $code)
            ->orWhere('order_number', $code)
            ->orWhere('phone', $code)
            ->with('items.product')
            ->first();

        if (!$order) {
            return back()->with('error', 'কোন অর্ডার পাওয়া যায়নি। দয়া করে সঠিক অর্ডার আইডি অথবা ফোন নাম্বার দিয়ে আবার চেষ্টা করুন।')->withInput();
        }

        return view('frontend.order_tracking.index', compact('order'));
    }
}
