<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\LandingPage;
use App\Models\GeneralSetting;
use App\Models\ShippingCharge;
use Illuminate\Http\Request;

class LandingPageController extends Controller
{
    public function show($slug)
    {
        // Try to find by slug directly
        $landingPage = LandingPage::where('slug', $slug)
            ->where('status', 'active')
            ->with('product')
            ->first();

        // If not found, it might be a prefix/slug combo
        // However, Laravel routing splits by /.
        // If we want to support prefix/slug, we need a separate route definition or a catch-all.
        
        if (!$landingPage) {
            abort(404);
        }

        $settings = GeneralSetting::first();
        $shippingCharges = ShippingCharge::where('status', true)->get();

        return view('frontend.landing_pages.show', compact('landingPage', 'settings', 'shippingCharges'));
    }

    public function showWithPrefix($prefix, $slug)
    {
        $landingPage = LandingPage::where('slug', $slug)
            ->where('custom_url_prefix', $prefix)
            ->where('status', 'active')
            ->with('product')
            ->firstOrFail();

        $settings = GeneralSetting::first();
        $shippingCharges = ShippingCharge::where('status', true)->get();

        return view('frontend.landing_pages.show', compact('landingPage', 'settings', 'shippingCharges'));
    }
    
    public function showWithPrefixAndSuffix($prefix, $suffix, $slug)
    {
        $landingPage = LandingPage::where('slug', $slug)
            ->where('custom_url_prefix', $prefix)
            ->where('custom_url_suffix', $suffix)
            ->where('status', 'active')
            ->with('product')
            ->firstOrFail();

        $settings = GeneralSetting::first();
        $shippingCharges = ShippingCharge::where('status', true)->get();

        return view('frontend.landing_pages.show', compact('landingPage', 'settings', 'shippingCharges'));
    }
}
