<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $categories = Category::whereNull('parent_id')->with('children')->get();
        $featuredProducts = Product::where('is_featured', true)->where('status', true)->latest()->take(8)->get();
        $newArrivals = Product::where('status', true)->latest()->take(50)->get();
        $allProducts = Product::where('status', true)->latest()->take(15)->get();

        return view('frontend.home', compact('categories', 'featuredProducts', 'newArrivals', 'allProducts'));
    }
}
