<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Order;

class DashboardController extends Controller
{
    public function index()
    {
        $orders = Auth::user()->orders()->latest()->paginate(10);
        return view('dashboard', compact('orders'));
    }

    public function orderDetails($id)
    {
        $order = Order::where('id', $id)->where('user_id', Auth::id())->with(['items.product', 'items.color', 'items.size'])->firstOrFail();
        return view('frontend.orders.show', compact('order'));
    }
}
