<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Laravel\Socialite\Facades\Socialite;

class SocialLoginController extends Controller
{
    public function redirectToGoogle()
    {
        return Socialite::driver('google')->redirect();
    }

    public function handleGoogleCallback()
    {
        try {
            $socialUser = Socialite::driver('google')->user();
            $this->_registerOrLoginUser($socialUser, 'google');
            return redirect()->intended('dashboard');
        } catch (\Exception $e) {
            return redirect()->route('login')->with('error', 'Google Login failed: ' . $e->getMessage());
        }
    }

    public function redirectToFacebook()
    {
        return Socialite::driver('facebook')->redirect();
    }

    public function handleFacebookCallback()
    {
        try {
            $socialUser = Socialite::driver('facebook')->user();
            $this->_registerOrLoginUser($socialUser, 'facebook');
            return redirect()->intended('dashboard');
        } catch (\Exception $e) {
            return redirect()->route('login')->with('error', 'Facebook Login failed: ' . $e->getMessage());
        }
    }

    protected function _registerOrLoginUser($socialUser, $provider)
    {
        $user = User::where('email', $socialUser->email)->first();

        if (!$user) {
            $user = new User();
            $user->name = $socialUser->name;
            $user->email = $socialUser->email;
            $user->password = Hash::make(Str::random(24));
            
            if ($provider == 'google') {
                $user->google_id = $socialUser->id;
            } else {
                $user->facebook_id = $socialUser->id;
            }
            
            if (isset($socialUser->avatar)) {
                $user->avatar = $socialUser->avatar;
            }
            
            $user->save();
        } else {
            // Update existing user with social ID if missing
            if ($provider == 'google' && empty($user->google_id)) {
                $user->google_id = $socialUser->id;
                $user->save();
            } elseif ($provider == 'facebook' && empty($user->facebook_id)) {
                $user->facebook_id = $socialUser->id;
                $user->save();
            }
        }

        Auth::login($user);
    }
}