<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GeneralSetting;
use Illuminate\Http\Request;

class ThemeController extends Controller
{
    private $themes = [
        'default' => [
            'name' => 'Main Theme',
            'description' => 'Standard Orange Theme (Default)',
            'colors' => [
                'primary' => '#ea580c', // orange-600
                'primary_hover' => '#c2410c', // orange-700
                'primary_light' => '#fff7ed', // orange-50
            ]
        ],
        'classic' => [
            'name' => 'Classic Theme',
            'description' => 'Traditional Blue Theme',
            'colors' => [
                'primary' => '#2563eb', // blue-600
                'primary_hover' => '#1d4ed8', // blue-700
                'primary_light' => '#eff6ff', // blue-50
            ]
        ],
        'modern' => [
            'name' => 'Modern Theme',
            'description' => 'Clean Green Theme',
            'colors' => [
                'primary' => '#059669', // emerald-600
                'primary_hover' => '#047857', // emerald-700
                'primary_light' => '#ecfdf5', // emerald-50
            ]
        ],
        'dark' => [
            'name' => 'Dark Theme',
            'description' => 'Night Mode Theme',
            'colors' => [
                'primary' => '#1f2937', // gray-800
                'primary_hover' => '#000000', // black
                'primary_light' => '#374151', // gray-700
            ]
        ]
    ];

    public function index()
    {
        $settings = GeneralSetting::first();
        $activeTheme = $settings->theme ?? 'default';
        $themes = $this->themes;
        
        return view('admin.settings.themes.index', compact('settings', 'themes', 'activeTheme'));
    }

    public function activate(Request $request)
    {
        $request->validate([
            'theme' => 'required|string|in:default,classic,modern,dark',
        ]);

        $settings = GeneralSetting::first();
        if (!$settings) {
            $settings = new GeneralSetting();
        }

        $settings->theme = $request->theme;
        $settings->save();

        return redirect()->route('admin.settings.themes.index')->with('success', 'Theme activated successfully!');
    }

    public function edit($theme)
    {
        if (!array_key_exists($theme, $this->themes)) {
            abort(404);
        }

        $settings = GeneralSetting::first();
        $themeConfig = $settings->theme_config ?? [];
        $currentConfig = $themeConfig[$theme] ?? $this->themes[$theme]['colors'];
        $themeDetails = $this->themes[$theme];

        return view('admin.settings.themes.edit', compact('theme', 'currentConfig', 'themeDetails'));
    }

    public function update(Request $request, $theme)
    {
        if (!array_key_exists($theme, $this->themes)) {
            abort(404);
        }

        $request->validate([
            'primary' => 'required|string',
            'primary_hover' => 'required|string',
            'primary_light' => 'required|string',
        ]);

        $settings = GeneralSetting::first();
        if (!$settings) {
            $settings = new GeneralSetting();
        }

        $themeConfig = $settings->theme_config ?? [];
        $themeConfig[$theme] = [
            'primary' => $request->primary,
            'primary_hover' => $request->primary_hover,
            'primary_light' => $request->primary_light,
        ];

        $settings->theme_config = $themeConfig;
        $settings->save();

        return redirect()->route('admin.settings.themes.edit', $theme)->with('success', 'Theme colors updated successfully!');
    }
}
