<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SocialMediaController extends Controller
{
    public function index()
    {
        $socials = \App\Models\SocialMedia::all();
        return view('admin.settings.social.index', compact('socials'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'icon' => 'nullable|string|max:255',
            'link' => 'nullable|url|max:255',
            'color' => 'nullable|string|max:255',
            'status' => 'boolean',
        ]);

        \App\Models\SocialMedia::create($request->all());

        return back()->with('success', 'Social media created successfully.');
    }

    public function update(Request $request, $id)
    {
        $social = \App\Models\SocialMedia::findOrFail($id);
        
        $request->validate([
            'name' => 'required|string|max:255',
            'icon' => 'nullable|string|max:255',
            'link' => 'nullable|url|max:255',
            'color' => 'nullable|string|max:255',
            'status' => 'boolean',
        ]);

        $social->update($request->all());

        return back()->with('success', 'Social media updated successfully.');
    }

    public function destroy($id)
    {
        $social = \App\Models\SocialMedia::findOrFail($id);
        $social->delete();

        return back()->with('success', 'Social media deleted successfully.');
    }

    public function toggleStatus($id)
    {
        $social = \App\Models\SocialMedia::findOrFail($id);
        $social->status = !$social->status;
        $social->save();

        return back()->with('success', 'Status updated successfully.');
    }
}
