<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ShippingCharge;

class ShippingChargeController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'area_name' => 'required|string|max:255',
            'charge_0_0_5' => 'required|numeric|min:0',
            'charge_0_5_1' => 'required|numeric|min:0',
            'charge_1_2' => 'required|numeric|min:0',
            'charge_over_2' => 'required|numeric|min:0',
            'status' => 'nullable|boolean',
        ]);

        $data = $request->all();
        $data['status'] = $request->has('status');

        ShippingCharge::create($data);

        return back()->with('success', 'Shipping charge created successfully.');
    }

    public function update(Request $request, $id)
    {
        $shippingCharge = ShippingCharge::findOrFail($id);

        $request->validate([
            'area_name' => 'required|string|max:255',
            'charge_0_0_5' => 'required|numeric|min:0',
            'charge_0_5_1' => 'required|numeric|min:0',
            'charge_1_2' => 'required|numeric|min:0',
            'charge_over_2' => 'required|numeric|min:0',
            'status' => 'nullable|boolean',
        ]);

        $data = $request->all();
        $data['status'] = $request->has('status');

        $shippingCharge->update($data);

        return back()->with('success', 'Shipping charge updated successfully.');
    }

    public function destroy($id)
    {
        $shippingCharge = ShippingCharge::findOrFail($id);
        $shippingCharge->delete();

        return back()->with('success', 'Shipping charge deleted successfully.');
    }

    public function toggleStatus($id)
    {
        $shippingCharge = ShippingCharge::findOrFail($id);
        $shippingCharge->status = !$shippingCharge->status;
        $shippingCharge->save();

        return back()->with('success', 'Status updated successfully.');
    }
}
