<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Review;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:reviews.manage');
    }

    public function index(Request $request)
    {
        $status = $request->query('status');

        $query = Review::with(['user', 'product'])->latest();

        if ($status) {
            $query->where('status', $status);
        }

        $reviews = $query->paginate(10);

        return view('admin.reviews.index', compact('reviews', 'status'));
    }

    public function update(Request $request, string $id)
    {
        $review = Review::findOrFail($id);
        
        $request->validate([
            'status' => 'required|in:pending,approved,rejected',
        ]);

        $review->update([
            'status' => $request->status,
        ]);

        return back()->with('success', 'Review status updated successfully.');
    }

    public function destroy(string $id)
    {
        $review = Review::findOrFail($id);
        $review->delete();

        return back()->with('success', 'Review deleted successfully.');
    }
}
