<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    public function sales()
    {
        // Basic sales report logic
        $salesData = Order::select(
            DB::raw('DATE(created_at) as date'),
            DB::raw('SUM(total_amount) as total')
        )
        ->where('status', '!=', 'cancelled')
        ->where('status', '!=', 'incomplete')
        ->groupBy('date')
        ->orderBy('date', 'desc')
        ->limit(30)
        ->get();

        return view('admin.reports.sales', compact('salesData'));
    }

    public function orders()
    {
        $orderCounts = Order::select('status', DB::raw('count(*) as total'))
            ->groupBy('status')
            ->get();
            
        return view('admin.reports.orders', compact('orderCounts'));
    }
}
