<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactSetting;

class ContactSettingController extends Controller
{
    public function index()
    {
        $contacts = ContactSetting::all();
        return view('admin.settings.contact.index', compact('contacts'));
    }

    public function create()
    {
        return view('admin.settings.contact.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'hotline_number' => 'nullable|string',
            'hot_mail' => 'nullable|email',
            'phone_number' => 'required|string',
            'whatsapp_number' => 'required|string',
            'email' => 'nullable|email',
            'address' => 'required|string',
            'google_map' => 'nullable|string',
            'status' => 'boolean',
        ]);

        $data = $request->all();
        $data['status'] = $request->has('status');

        ContactSetting::create($data);

        return redirect()->route('admin.settings.contact')->with('success', 'Contact created successfully.');
    }

    public function edit($id)
    {
        $contact = ContactSetting::findOrFail($id);
        return view('admin.settings.contact.edit', compact('contact'));
    }

    public function update(Request $request, $id)
    {
        $contact = ContactSetting::findOrFail($id);
        
        $request->validate([
            'hotline_number' => 'nullable|string',
            'hot_mail' => 'nullable|email',
            'phone_number' => 'required|string',
            'whatsapp_number' => 'required|string',
            'email' => 'nullable|email',
            'address' => 'required|string',
            'google_map' => 'nullable|string',
            'status' => 'boolean',
        ]);
        
        $data = $request->all();
        $data['status'] = $request->has('status');

        $contact->update($data);

        return redirect()->route('admin.settings.contact')->with('success', 'Contact updated successfully.');
    }
    
    public function destroy($id)
    {
         $contact = ContactSetting::findOrFail($id);
         $contact->delete();
         return back()->with('success', 'Contact deleted successfully.');
    }

    public function toggleStatus($id)
    {
        $contact = ContactSetting::findOrFail($id);
        $contact->status = !$contact->status;
        $contact->save();

        return back()->with('success', 'Status updated successfully.');
    }
}
